/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.RoomEventDialog;
import com.megacrit.cardcrawl.helpers.Hitbox;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.MathHelper;
import com.megacrit.cardcrawl.rooms.AbstractRoom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class AbstractEvent {
    protected Texture img = null;
    protected float drawX;
    protected float drawY;
    protected float imgWidth;
    protected float imgHeight;
    protected Color imgColor = Color.WHITE.cpy();
    protected Hitbox hitbox = null;
    public String bgmKey = null;
    public float panelAlpha = 0.0f;
    public boolean hideAlpha = false;
    public boolean isActive = true;
    public boolean hasFocus = false;
    protected String body = null;
    public boolean callOnce = false;
    public float waitTimer = 1.5f;
    protected boolean waitForInput = false;
    public boolean hasDialog = false;
    protected int screenNum = 0;
    public static EventType type = EventType.IMAGE;
    public static String NAME;
    public static String[] DESCRIPTIONS;
    public static String[] OPTIONS;
    public ArrayList<Integer> optionsSelected = new ArrayList();

    public AbstractEvent() {
        type = EventType.ROOM;
    }

    protected void initializeImage(String imgUrl, float x, float y) {
        this.img = ImageMaster.loadImage(imgUrl);
        this.drawX = x;
        this.drawY = y;
        this.imgWidth = (float)this.img.getWidth() * Settings.scale;
        this.imgHeight = (float)this.img.getHeight() * Settings.scale;
    }

    public void onEnterRoom() {
    }

    protected abstract void buttonEffect(int var1);

    public void update() {
        if (this.waitTimer > 0.0f) {
            this.waitTimer -= Gdx.graphics.getDeltaTime();
            if (this.waitTimer < 0.0f && this.hasDialog) {
                AbstractDungeon.dialog.show(this.body);
                this.waitTimer = 0.0f;
            }
        } else {
            this.panelAlpha = AbstractDungeon.getCurrRoom().phase != AbstractRoom.RoomPhase.COMBAT && !this.hideAlpha ? MathHelper.fadeLerpSnap(this.panelAlpha, 0.66f) : MathHelper.fadeLerpSnap(this.panelAlpha, 0.0f);
        }
        if (!RoomEventDialog.waitForInput) {
            this.buttonEffect(RoomEventDialog.getSelectedOption());
        }
    }

    public void logInput(int buttonPressed) {
        this.optionsSelected.add(buttonPressed);
    }

    protected void openMap() {
        AbstractDungeon.getCurrRoom().phase = AbstractRoom.RoomPhase.COMPLETE;
        AbstractDungeon.dungeonMapScreen.open(false);
    }

    public void render(SpriteBatch sb) {
        if (this.img != null) {
            sb.setColor(this.imgColor);
            sb.draw(this.img, this.drawX, this.drawY, this.imgWidth, this.imgHeight);
        }
        if (this.hitbox != null) {
            this.hitbox.render(sb);
            if (this.img != null && this.hitbox.hovered) {
                sb.setBlendFunction(770, 1);
                sb.setColor(new Color(1.0f, 1.0f, 1.0f, 0.3f));
                sb.draw(this.img, this.drawX, this.drawY, this.imgWidth, this.imgHeight);
                sb.setBlendFunction(770, 771);
            }
        }
    }

    public void renderRoomEventPanel(SpriteBatch sb) {
        sb.setColor(new Color(0.0f, 0.0f, 0.0f, this.panelAlpha));
        sb.draw(ImageMaster.EVENT_ROOM_PANEL, 0.0f, (float)Settings.HEIGHT - 475.0f * Settings.scale, (float)Settings.WIDTH, 300.0f * Settings.scale);
    }

    public void showProceedScreen(String bodyText) {
        RoomEventDialog.updateBodyText(bodyText);
        RoomEventDialog.updateDialogOption(0, "[ #bProceed ]");
        RoomEventDialog.clearRemainingOptions();
        this.screenNum = 99;
    }

    public void renderAboveTopPanel(SpriteBatch sb) {
    }

    public void reopen() {
    }

    public static void logMetric(String eventName, String playerChoice) {
        AbstractEvent.logMetric(eventName, playerChoice, 0);
    }

    public static void logMetric(String eventName, String playerChoice, int damageTaken) {
        HashMap<String, Object> choice = new HashMap<String, Object>();
        choice.put("event_name", eventName);
        choice.put("player_choice", playerChoice);
        choice.put("damage_taken", damageTaken);
        choice.put("floor", AbstractDungeon.floorNum);
        CardCrawlGame.metricData.event_choices.add(choice);
    }

    public HashMap<String, Serializable> getLocStrings() {
        HashMap<String, Serializable> data = new HashMap<String, Serializable>();
        data.put("name", (Serializable)((Object)NAME));
        data.put("moves", (Serializable)DESCRIPTIONS);
        data.put("dialogs", (Serializable)OPTIONS);
        return data;
    }

    public static enum EventType {
        TEXT,
        IMAGE,
        ROOM;

    }
}

